<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;

class RunQueueWorker extends Command
{
    protected $signature = 'queue:run-worker';
    protected $description = 'Run the queue worker';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        Log::info('Running queue worker...');
        $this->info('Running queue worker...');

        Artisan::call('queue:work', [
            '--stop-when-empty' => true,
            '--timeout' => 120,
        ]);

        Log::info('Queue worker finished.');
        $this->info('Queue worker finished.');
    }
}
