<?php

// app/Http/Middleware/CheckSubscription.php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Subscription;

class CheckSubscription
{
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();
        $gameGroupId = $request->route('id');
        $type = $this->getType($request->route()->getPrefix());

        $subscription = Subscription::where('user_id', $user->id)
            ->where(function ($query) use ($type, $gameGroupId) {
                switch ($type) {
                    case 'vip':
                        $query->where('vip_game_group_id', $gameGroupId);
                        break;
                    case 'vvip':
                        $query->where('vvip_game_group_id', $gameGroupId);
                        break;
                    case 'correct_score':
                        $query->where('correct_score_game_group_id', $gameGroupId);
                        break;
                }
            })
            ->where('expires_at', '>', now())
            ->first();

        if (!$subscription) {
            return response()->json(['message' => 'Unauthorized - No active subscription'], 403);
        }

        return $next($request);
    }

    private function getType($prefix)
    {
        switch ($prefix) {
            case 'vip-games':
                return 'vip';
            case 'vvip-games':
                return 'vvip';
            case 'correct-score-games':
                return 'correct_score';
            default:
                return null;
        }
    }
}

