<?php

// app/Http/Middleware/EnsureVipAccess.php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnsureVipAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Assuming you have a 'has_vip_access' attribute on your User model
        if (Auth::check() && Auth::user()->has_vip_access) {
            return $next($request);
        }

        return response()->json(['message' => 'Unauthorized - VIP access required'], 403);
    }
}
