<?php

// app/Http/Middleware/EnsureVvipAccess.php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EnsureVvipAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        // Assuming you have a 'has_vvip_access' attribute on your User model
        if (Auth::check() && Auth::user()->has_vvip_access) {
            return $next($request);
        }

        return response()->json(['message' => 'Unauthorized - VVIP access required'], 403);
    }
}
