<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class StatusUpdated extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $status;
    public $type;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($status, $type)
    {
        $this->status = $status;
        $this->type = $type;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.status-updated')
            ->with([
                'status' => $this->status,
                'type' => $this->type,
            ]);
    }
}
