<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TierGame extends Model
{
    use HasFactory;

    protected $fillable = [
        'tier_game_group_id',
        'date_time',
        'home_team',
        'away_team',
        'league',
        'option',
        'odds',
        'status',
    ];

    protected $casts = [
        'date_time' => 'datetime',
        'odds' => 'decimal:2',
    ];

    public function group()
    {
        return $this->belongsTo(TierGameGroup::class, 'tier_game_group_id');
    }

    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    public function scopeWon($query)
    {
        return $query->where('status', 'won');
    }

    public function scopeLost($query)
    {
        return $query->where('status', 'lost');
    }

    public function scopeToday($query)
    {
        return $query->whereDate('date_time', today());
    }

    public function scopeUpcoming($query)
    {
        return $query->where('date_time', '>=', now());
    }
}
