<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TierGameGroup extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'price' => 'decimal:2',
        'selling' => 'boolean',
    ];

    public function subscriptionPlan()
    {
        return $this->belongsTo(SubscriptionPlan::class);
    }

    public function games()
    {
        return $this->hasMany(TierGame::class, 'tier_game_group_id');
    }

    public function scopeForTier($query, $planId)
    {
        return $query->where('subscription_plan_id', $planId);
    }

    public function scopeSelling($query)
    {
        return $query->where('selling', true);
    }
}
