<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WinningTicket extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'image_path',
        'title',
        'description',
        'amount_won',
        'status',
        'admin_notes',
        'reviewed_at',
    ];

    protected $casts = [
        'amount_won' => 'decimal:2',
        'reviewed_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    public function scopeApproved($query)
    {
        return $query->where('status', 'approved');
    }

    public function scopeRejected($query)
    {
        return $query->where('status', 'rejected');
    }
}
