<?php

use App\Http\Middleware\CheckSubscription;
use App\Http\Middleware\EnsureAdmin;
use App\Http\Middleware\EnsureVipAccess;
use App\Http\Middleware\EnsureVvipAccess;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use App\Http\Middleware\CorsMiddleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        // Register your custom CORS middleware here
        $middleware->append(CorsMiddleware::class);

        // Register your custom middlewares here
        $middleware->alias([
            'admin' => EnsureAdmin::class,
            'vip' => EnsureVipAccess::class,
            'vvip' => EnsureVvipAccess::class,
           'check_subscription'=> CheckSubscription::class
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
