<?php

// database/migrations/2024_06_22_100428_create_vip_game_groups_table.php
// database/migrations/2024_06_22_100428_create_vip_game_groups_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        // Drop the table if it exists to avoid conflicts
        Schema::dropIfExists('vip_game_groups');

        Schema::create('vip_game_groups', function (Blueprint $table) {
            $table->id();
            $table->decimal('price', 8, 2);
            $table->string('status')->nullable();
            $table->string('sporty_booking')->nullable();
            $table->string('msport_booking')->nullable();
            $table->string('betway_booking')->nullable();
            $table->string('onex_booking')->nullable();
            $table->boolean('selling')->default(false);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('vip_game_groups');
    }
};
