<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('correct_score_game_groups', function (Blueprint $table) {
            $table->id();
            $table->decimal('price', 8, 2);
            $table->string('status')->nullable();
            $table->string('sporty_booking')->nullable();
            $table->string('msport_booking')->nullable();
            $table->string('betway_booking')->nullable();
            $table->string('onex_booking')->nullable();
            $table->boolean('selling')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('correct_score_game_groups');
    }
};
