<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('games', function (Blueprint $table) {
            $table->id();
            $table->dateTime('date_time');
            $table->string('home_team');
            $table->string('away_team');
            $table->string('league');
            $table->string('option');
            $table->string('status')->nullable();
            $table->string('sporty_booking')->nullable();
            $table->string('msport_booking')->nullable();
            $table->string('betway_booking')->nullable();
            $table->string('onex_booking')->nullable();
            $table->decimal('odds', 8, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void

    {
        Schema::dropIfExists('games');
    }
};
