<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vip_games', function (Blueprint $table) {
            $table->id();
            $table->dateTime('date_time');
            $table->string('home_team');
            $table->string('away_team');
            $table->string('league');
            $table->string('option');
            $table->decimal('odds', 8, 2);
            $table->foreignId('vip_game_group_id')->constrained('vip_game_groups')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->dropForeign(['vip_game_group_id']);
        });

        Schema::dropIfExists('vip_games');
    }
};
