<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('correct_score_games', function (Blueprint $table) {
            $table->id();
            $table->dateTime('date_time');
            $table->string('home_team');
            $table->string('away_team');
            $table->string('league');
            $table->string('option');
            $table->decimal('odds', 8, 2);
            $table->foreignId('correct_score_game_group_id')->constrained('correct_score_game_groups')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Drop the foreign key constraint in the subscriptions table first
        Schema::table('subscriptions', function (Blueprint $table) {
            $table->dropForeign(['correct_score_game_group_id']);
        });

        // Then drop the correct_score_games table
        Schema::dropIfExists('correct_score_games');
    }
};
