<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('vip_game_group_id')->nullable()->constrained('vip_game_groups')->onDelete('cascade');
            $table->foreignId('vvip_game_group_id')->nullable()->constrained('vvip_game_groups')->onDelete('cascade');
            $table->decimal('amount_paid', 8, 2);
            $table->foreignId('correct_score_game_group_id')->nullable()->constrained('correct_score_game_groups')->onDelete('cascade');
            $table->timestamp('expires_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};
