<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Create tier game groups table (like vip_game_groups)
        Schema::create('tier_game_groups', function (Blueprint $table) {
            $table->id();
            $table->foreignId('subscription_plan_id')->constrained()->onDelete('cascade');
            $table->decimal('price', 8, 2)->nullable();
            $table->string('status')->nullable(); // won, lost, pending
            $table->string('sporty_booking')->nullable();
            $table->string('msport_booking')->nullable();
            $table->string('betway_booking')->nullable();
            $table->string('onex_booking')->nullable();
            $table->boolean('selling')->default(true);
            $table->timestamps();
            
            $table->index(['subscription_plan_id', 'created_at']);
        });

        // Create tier games table (like vip_games)
        Schema::create('tier_games', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tier_game_group_id')->constrained()->onDelete('cascade');
            $table->dateTime('date_time');
            $table->string('home_team');
            $table->string('away_team');
            $table->string('league');
            $table->string('option'); // bet type/prediction
            $table->decimal('odds', 8, 2);
            $table->string('status')->nullable(); // won, lost, pending
            $table->timestamps();
            
            $table->index('date_time');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tier_games');
        Schema::dropIfExists('tier_game_groups');
    }
};
