<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exchange_rates', function (Blueprint $table) {
            $table->id();
            $table->string('currency_code')->unique(); // USD, EUR, GBP, etc.
            $table->string('currency_name'); // US Dollar, Euro, etc.
            $table->decimal('rate', 12, 4); // Rate to NGN (e.g., 1 USD = 1650.0000 NGN)
            $table->boolean('is_active')->default(true);
            $table->foreignId('updated_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamps();
        });

        // Insert default USD rate
        DB::table('exchange_rates')->insert([
            'currency_code' => 'USD',
            'currency_name' => 'US Dollar',
            'rate' => 1600.00,
            'is_active' => true,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exchange_rates');
    }
};
