<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('exchange_rates', function (Blueprint $table) {
            $table->decimal('usd_rate', 12, 4)->default(1)->after('rate');
            $table->decimal('ngn_rate', 12, 4)->default(1600)->after('usd_rate');
        });

        // Update existing record
        DB::table('exchange_rates')
            ->where('currency_code', 'USD')
            ->update([
                'usd_rate' => 1,
                'ngn_rate' => 1600,
            ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('exchange_rates', function (Blueprint $table) {
            $table->dropColumn(['usd_rate', 'ngn_rate']);
        });
    }
};
