<?php

namespace Database\Seeders;

use App\Models\SubscriptionPlan;
use Illuminate\Database\Seeder;

class SubscriptionPlanSeeder extends Seeder
{
    public function run(): void
    {
        $plans = [
            [
                'name' => 'Daily Plan',
                'slug' => 'daily',
                'description' => 'Access all premium features for 1 day',
                'price' => 5.00,
                'duration_days' => 1,
                'duration_type' => 'daily',
                'features' => ['Full access to VIP picks', 'Daily predictions', '24/7 support'],
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Weekly Plan',
                'slug' => 'weekly',
                'description' => 'Access all premium features for 7 days',
                'price' => 25.00,
                'duration_days' => 7,
                'duration_type' => 'weekly',
                'features' => ['Full access to VIP picks', 'Weekly predictions', '24/7 support', 'Priority notifications'],
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Monthly Plan',
                'slug' => 'monthly',
                'description' => 'Access all premium features for 30 days',
                'price' => 75.00,
                'duration_days' => 30,
                'duration_type' => 'monthly',
                'features' => ['Full access to VIP picks', 'Monthly predictions', '24/7 support', 'Priority notifications', 'Exclusive tips'],
                'is_active' => true,
                'sort_order' => 3,
            ],
        ];

        foreach ($plans as $plan) {
            SubscriptionPlan::updateOrCreate(
                ['slug' => $plan['slug']],
                $plan
            );
        }
    }
}
