<?php

// routes/api.php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\CorrectScoreGameController;
use App\Http\Controllers\CreditsController;
use App\Http\Controllers\FeatureImageController;
use App\Http\Controllers\GameController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\PasswordResetController;
use App\Http\Controllers\PushNotificationController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\TestimonialController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\VipGameController;
use App\Http\Controllers\VvipGameController;
use App\Http\Controllers\WinningTicketController;
use App\Http\Controllers\SubscriptionPlanController;
use App\Http\Controllers\TierGameController;
use App\Http\Controllers\ExchangeRateController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

Route::post('register', [AuthController::class, 'register']);
Route::post('login', [AuthController::class, 'login']);
Route::middleware('auth:sanctum')->post('logout', [AuthController::class, 'logout']);

Route::get('auth/google', [AuthController::class, 'redirectToGoogle']);
Route::get('auth/google/callback', [AuthController::class, 'handleGoogleCallback']);

// Add this route inside your auth:sanctum middleware group
Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    Route::delete('users/{id}', [UserController::class, 'destroy']);
    Route::get('admin/users/search', [UserController::class, 'search']);
});

// routes/api.php



// Add these routes inside your auth:sanctum middleware group
Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    Route::post('notifications', [NotificationController::class, 'store']);
    Route::post('notify-users', [NotificationController::class, 'notifyUsers']);
    Route::delete('notifications/{id}', [NotificationController::class, 'destroy']);
});


Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('notifications', [NotificationController::class, 'index']);
    // Route to get unseen notifications count
    Route::get('/notifications/unseen-count', [NotificationController::class, 'unseenCount'])->middleware('auth');

// Route to mark notifications as seen
    Route::post('/notifications/mark-as-seen', [NotificationController::class, 'markAsSeen'])->middleware('auth');

    Route::put('user/update-profile', [UserController::class, 'updateProfile']);
    Route::put('user/change-password', [UserController::class, 'changePassword']);

    Route::get('/testimonials', [TestimonialController::class, 'index']);
    Route::post('/testimonials', [TestimonialController::class, 'store']);
    Route::patch('/testimonials/{id}', [TestimonialController::class, 'update']);
    Route::delete('/testimonials/{id}', [TestimonialController::class, 'destroy']);

});

Route::get('games', [GameController::class, 'index']);
Route::get('/all-testimonials', [TestimonialController::class, 'getTestimonials']);
Route::get('all-games', [GameController::class, 'getAllGames']);
Route::get('games/booking/{bookingCode}', [GameController::class, 'getGamesByBookingCode']);
Route::get('vvip-games', [VvipGameController::class, 'index']);
Route::get('correct-score-games', [CorrectScoreGameController::class, 'index']);
Route::get('vip-games', [VipGameController::class, 'index']);
Route::get('correct-score-games', [CorrectScoreGameController::class, 'index']);
Route::get('/games-by-date', [GameController::class, 'getGamesByDateRange']);
Route::get('/vip-games-by-date', [VipGameController::class, 'getVIPGamesByDateRange']);
Route::get('/vvip-games-by-date', [VvipGameController::class, 'getVVIPGamesByDateRange']);
Route::get('/correct-score-games-by-date', [CorrectScoreGameController::class, 'getCorrectScoreGamesByDateRange']);

// Routes for regular games
Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    Route::get('credits', [CreditsController::class, 'getCredits']);
    Route::post('/testimonials/approve/{id}', [TestimonialController::class, 'approve']);
    Route::post('games', [GameController::class, 'store']);
    Route::get('games/{id}', [GameController::class, 'show']);
    Route::put('games/{id}', [GameController::class, 'update']);
    Route::patch('games/{id}', [GameController::class, 'updateStatus']);
    Route::delete('games/{id}', [GameController::class, 'destroy']);
});

// Routes for VIP games
Route::middleware(['auth:sanctum', 'admin'])->group(function () {

    Route::post('vip-games', [VipGameController::class, 'store']);
    Route::get('vip-games/{id}', [VipGameController::class, 'show']);
    Route::put('vip-games/{id}', [VipGameController::class, 'update']);
    Route::patch('vip-games/{id}', [VipGameController::class, 'updateStatus']);
    Route::delete('vip-games/{id}', [VipGameController::class, 'destroy']);
});


// Routes for VVIP games
Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    Route::post('vvip-games', [VvipGameController::class, 'store']);
    Route::get('vvip-games/{id}', [VvipGameController::class, 'show']);
    Route::put('vvip-games/{id}', [VvipGameController::class, 'update']);
    Route::patch('vvip-games/{id}', [VvipGameController::class, 'updateStatus']);
    Route::delete('vvip-games/{id}', [VvipGameController::class, 'destroy']);
});

Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    Route::get('/service-users', [SubscriptionController::class, 'getUsersWithSubscriptions']);
    Route::post('correct-score-games', [CorrectScoreGameController::class, 'store']);
    Route::get('correct-score-games/{id}', [CorrectScoreGameController::class, 'show']);
    Route::put('correct-score-games/{id}', [CorrectScoreGameController::class, 'update']);
    Route::patch('correct-score-games/{id}', [CorrectScoreGameController::class, 'updateStatus']);
    Route::delete('correct-score-games/{id}', [CorrectScoreGameController::class, 'destroy']);
});

Route::middleware(['auth:sanctum'])->group(function () {
    Route::post('subscribe', [SubscriptionController::class, 'subscribe']);
    Route::get('check-subscription/{type}/{id}', [SubscriptionController::class, 'checkSubscription']);
    Route::get('subscribed-users', [SubscriptionController::class, 'getSubscribedUsers']);
    Route::get('all-users', [SubscriptionController::class, 'getAllUsers']);
    Route::get('/unsubscribed-users', [SubscriptionController::class, 'getUnsubscribedUsers']);
    Route::get('/recent-users', [SubscriptionController::class, 'getRecentUsers']);
    Route::get('/user/subscriptions', [SubscriptionController::class, 'getUserSubscriptions']);

});


//Route::get('/user/{userId}/subscriptions', [SubscriptionController::class, 'getUserSubscriptions']);

Route::post('/verify-payment', [SubscriptionController::class, 'verifyPayment']);
Route::post('/initialize-payment', [SubscriptionController::class, 'initializeTransaction']);

Route::post('password/otp', [PasswordResetController::class, 'sendResetOtp']);
Route::post('password/reset-with-otp', [PasswordResetController::class, 'resetPasswordWithOtp']);

Route::get('/app-feature-images', [FeatureImageController::class, 'index']);
Route::post('/app-feature-image', [FeatureImageController::class, 'store']);
Route::delete('/app-feature-images/{id}', [FeatureImageController::class, 'destroy']);

Route::post('/store-device-token', [PushNotificationController::class, 'storeToken']);
Route::post('/send-push-notification', [PushNotificationController::class, 'sendPushNotification']);

// Manual Payment Routes
Route::post('/manual-payment-request', [SubscriptionController::class, 'submitManualPayment']);
Route::get('/manual-payment-status/{id}', [SubscriptionController::class, 'getManualPaymentStatus']);

Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    Route::get('/admin/manual-payments', [SubscriptionController::class, 'getManualPaymentsForAdmin']);
    Route::put('/admin/manual-payment/{id}', [SubscriptionController::class, 'updateManualPaymentStatus']);
});

Route::middleware('auth:sanctum', 'throttle:60,1')->group(function () {
    // Protected routes
});

// Winning Tickets Routes
// Public - view approved winning tickets gallery
Route::get('/winning-tickets', [WinningTicketController::class, 'index']);

// Authenticated user routes
Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('/my-winning-tickets', [WinningTicketController::class, 'myTickets']);
    Route::post('/winning-tickets', [WinningTicketController::class, 'store']);
    Route::delete('/winning-tickets/{id}', [WinningTicketController::class, 'destroyOwn']);
});

// Admin routes for winning tickets
Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    Route::get('/admin/winning-tickets', [WinningTicketController::class, 'adminIndex']);
    Route::get('/admin/winning-tickets/pending-count', [WinningTicketController::class, 'pendingCount']);
    Route::get('/admin/winning-tickets/user/{userId}', [WinningTicketController::class, 'getByUser']);
    Route::post('/admin/winning-tickets/{id}/approve', [WinningTicketController::class, 'approve']);
    Route::post('/admin/winning-tickets/{id}/reject', [WinningTicketController::class, 'reject']);
    Route::delete('/admin/winning-tickets/{id}', [WinningTicketController::class, 'adminDestroy']);
});

// ==================== SUBSCRIPTION PLANS ROUTES ====================

// Public - view available subscription plans
Route::get('/subscription-plans', [SubscriptionPlanController::class, 'index']);
Route::get('/subscription-plans/{slug}', [SubscriptionPlanController::class, 'show']);

// Authenticated user routes for subscriptions
Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('/my-subscription', [SubscriptionPlanController::class, 'mySubscription']);
    Route::post('/subscribe', [SubscriptionPlanController::class, 'requestSubscription']);
    Route::get('/check-subscription-access', [SubscriptionPlanController::class, 'checkAccess']);
});

// Paystack payment verification for subscription plans
Route::post('/subscription-plans/verify-payment', [SubscriptionPlanController::class, 'verifyPaystackPayment']);

// Admin routes for subscription plans management
Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    // Plan management
    Route::get('/admin/subscription-plans', [SubscriptionPlanController::class, 'adminIndex']);
    Route::post('/admin/subscription-plans', [SubscriptionPlanController::class, 'store']);
    Route::put('/admin/subscription-plans/{id}', [SubscriptionPlanController::class, 'update']);
    Route::delete('/admin/subscription-plans/{id}', [SubscriptionPlanController::class, 'destroy']);
    
    // User subscription management
    Route::get('/admin/user-subscriptions', [SubscriptionPlanController::class, 'adminSubscriptions']);
    Route::get('/admin/user-subscriptions/stats', [SubscriptionPlanController::class, 'adminStats']);
    Route::get('/admin/user-subscriptions/user/{userId}', [SubscriptionPlanController::class, 'getUserSubscriptions']);
    Route::post('/admin/user-subscriptions/activate', [SubscriptionPlanController::class, 'activateSubscription']);
    Route::post('/admin/user-subscriptions/{id}/extend', [SubscriptionPlanController::class, 'extendSubscription']);
    Route::post('/admin/user-subscriptions/{id}/cancel', [SubscriptionPlanController::class, 'cancelSubscription']);
});

// ==================== TIER GAMES ROUTES ====================

// User routes - get game groups for their subscription tier
Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('/my-tier-games', [TierGameController::class, 'myGames']);
    Route::get('/my-tier-games/{id}', [TierGameController::class, 'showGroup']);
});

// Admin routes for tier game groups management (like VIP games)
Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    // Group CRUD
    Route::get('/admin/tier-games', [TierGameController::class, 'index']);
    Route::get('/admin/tier-games/stats', [TierGameController::class, 'stats']);
    Route::get('/admin/tier-games/plan/{planId}', [TierGameController::class, 'getByDate']);
    Route::get('/admin/tier-games/{id}', [TierGameController::class, 'show']);
    Route::post('/admin/tier-games', [TierGameController::class, 'store']);
    Route::put('/admin/tier-games/{id}', [TierGameController::class, 'update']);
    Route::delete('/admin/tier-games/{id}', [TierGameController::class, 'destroy']);
    
    // Group status
    Route::post('/admin/tier-games/{id}/status', [TierGameController::class, 'updateStatus']);
    
    // Transfer & Duplicate
    Route::post('/admin/tier-games/{id}/transfer', [TierGameController::class, 'transfer']);
    Route::post('/admin/tier-games/{id}/duplicate', [TierGameController::class, 'duplicate']);
    Route::post('/admin/tier-games/{id}/duplicate-all', [TierGameController::class, 'duplicateToAll']);
});

// ==================== EXCHANGE RATES ROUTES ====================

// Public - get exchange rates
Route::get('/exchange-rates', [ExchangeRateController::class, 'index']);
Route::get('/exchange-rates/usd', [ExchangeRateController::class, 'usdRate']);
Route::get('/exchange-rates/{currencyCode}', [ExchangeRateController::class, 'show']);

// Admin routes for exchange rate management
Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    Route::get('/admin/exchange-rates', [ExchangeRateController::class, 'adminIndex']);
    Route::post('/admin/exchange-rates', [ExchangeRateController::class, 'store']);
    Route::put('/admin/exchange-rates/{id}', [ExchangeRateController::class, 'update']);
    Route::put('/admin/exchange-rates/usd/rate', [ExchangeRateController::class, 'updateUsdRate']);
    Route::delete('/admin/exchange-rates/{id}', [ExchangeRateController::class, 'destroy']);
});

